//#pragma GCC optimize("O3")
//#pragma GCC optimize("unroll-loops")
//#pragma GCC target("avx,avx2,fma,sse,sse2,sse3,sse4,popcnt")
#include <bitset>
#include <sstream>
#include <iostream>
#include <algorithm>
#include <iomanip>
#include <vector>
#include <map>
#include <set>
#include <utility>
#include <cmath>
#include <iterator>
#include <fstream>
#include <list>
#include <cstdlib>
#include <stdio.h>
#include <stack>
#include <queue>
#include <random>
#include <string>
#include <functional>
#include <chrono>
#include <numeric>
#include <climits>
#include <tuple>
#include <cstring>
#include <unordered_set>
#include <unordered_map>

using namespace std;

typedef string str;
typedef long long ll;
typedef unsigned long long ull;
typedef long double ld;
typedef pair<int, int> pii;
typedef pair<ll, ll> pll;
typedef pair<ld, ld> pld;
typedef pair<ll, pair<ll, ll>> tll;

const int maxlg = 19;
const ll dim = 1003;
const ll inf = LLONG_MAX - 1;
const int iinf = INT_MAX - 1;
const ll mod = 998244353;

#define S second
#define F first
#define endl '\n'
#define null NULL

struct Node {
    int child[10];
    bool end = false;
    ll value = -1;
    Node() {
        fill(child, child + 10, -1);
    }
};

vector<Node> trie(1);
vector<vector<ll>> groups;

void insert_number(ll num) {
    string s = to_string(num);
    int v = 0;
    for (char c : s) {
        int d = c - '0';
        if (trie[v].child[d] == -1) {
            trie[v].child[d] = trie.size();
            trie.emplace_back();
        }
        v = trie[v].child[d];
    }
    trie[v].end = true;
    trie[v].value = num;
}

vector<int> dfs(int v) {
    vector<int> ids;
    for (int d = 0; d < 10; ++d) {
        int to = trie[v].child[d];
        if (to != -1) {
            auto sub = dfs(to);
            ids.insert(ids.end(), sub.begin(), sub.end());
        }
    }

    if (trie[v].end) {
        if (ids.empty()) {
            groups.push_back({trie[v].value});
            ids.push_back((int)groups.size() - 1);
        } else {
            groups[ids[0]].push_back(trie[v].value);
        }
    }
    return ids;
}

int main() {
    ios::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);

    int n;
    cin >> n;
    vector<ll> a(n);
    for (int i = 0; i < n; ++i) {
        cin >> a[i];
        insert_number(a[i]);
    }

    dfs(0);

    cout << groups.size() << endl;
    for (auto &g: groups) {
        cout << g.size() << endl;
        for (auto x: g) cout << x << " ";
        cout << endl;
    }
    
    return 0;
}


